/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.OutputStream;

public final class BMPWriter {
    public static void write(Image image, OutputStream o) throws Exception {
        int[] pixels = null;
        int w = 0;
        int h = 0;
        try {
            w = image.getWidth(null);
            h = image.getHeight(null);
            PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, true);
            pg.grabPixels();
            pixels = (int[])pg.getPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        BMPWriter.write24BitBMP(pixels, w, h, o);
    }

    static void printStatus(int status) {
        String s = "";
        if ((status & 0x80) != 0) {
            s = s + " ABORT";
        }
        if ((status & 0x20) != 0) {
            s = s + " ALLBITS";
        }
        if ((status & 0x40) != 0) {
            s = s + " ERROR";
        }
        if ((status & 8) != 0) {
            s = s + " SOMEBITS";
        }
        if ((status & 0x10) != 0) {
            s = s + " FRAMEBITS";
        }
        System.out.println("Status: " + s);
    }

    public static void write24BitBMP(int[] pixels, int w, int h, OutputStream o) throws Exception {
        int padding = (4 - w * 3 % 4) % 4;
        int imageSize = (w * 3 + padding) * h;
        byte[] picture = new byte[imageSize];
        int ptr = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pixel = pixels[(h - 1 - y) * w + x];
                picture[ptr++] = (byte)(pixel & 0xFF);
                picture[ptr++] = (byte)(pixel >> 8 & 0xFF);
                picture[ptr++] = (byte)(pixel >> 16 & 0xFF);
            }
            for (int cnt = 0; cnt < padding; ++cnt) {
                picture[ptr++] = 0;
            }
        }
        BMPWriter.writeBMPFile(o, imageSize, w, h, 24, picture);
    }

    protected static void writeBMPFile(OutputStream o, int imageSize, int w, int h, int bitDepth, byte[] buffer) throws Exception {
        DataOutputStream out = new DataOutputStream(o);
        BMPWriter.writeShort(out, 19778);
        BMPWriter.writeInt(out, imageSize + 54);
        BMPWriter.writeShort(out, 0);
        BMPWriter.writeShort(out, 0);
        BMPWriter.writeInt(out, 54);
        BMPWriter.writeInt(out, 40);
        BMPWriter.writeInt(out, w);
        BMPWriter.writeInt(out, h);
        BMPWriter.writeShort(out, 1);
        BMPWriter.writeShort(out, bitDepth);
        BMPWriter.writeInt(out, 0);
        BMPWriter.writeInt(out, imageSize);
        BMPWriter.writeInt(out, 2835);
        BMPWriter.writeInt(out, 2835);
        BMPWriter.writeInt(out, 0);
        BMPWriter.writeInt(out, 0);
        out.write(buffer, 0, imageSize);
        out.close();
    }

    private static void writeInt(DataOutputStream out, int number) throws Exception {
        out.writeByte(number & 0xFF);
        out.writeByte(number >> 8 & 0xFF);
        out.writeByte(number >> 16 & 0xFF);
        out.writeByte(number >> 24 & 0xFF);
    }

    private static void writeShort(DataOutputStream out, int number) throws Exception {
        out.writeByte(number & 0xFF);
        out.writeByte(number >> 8 & 0xFF);
    }
}

